// ActionScript file
package  {
	
	import flash.display.Sprite;
	import flash.display.Shape;
	import flash.text.TextField;
	import flash.text.TextFormat;

	
	public class XYScene extends Sprite{
		
		
		// Constants:
		const originX:int= 330;
		const originY:int=650;
		const relevanceMax:int=650;
		const relevanceStep:int=65;
		const timeStep:int=50;
		const timeMax:int= 1250;
		
		// Public Properties:
		// Private Properties:
	
		// Initialization:
		public function XYScene() { 
		
		for(var i:int=1; i<relevanceMax/relevanceStep; i++){
			var myLine:Shape = new Shape();
			myLine.graphics.lineStyle(1,0xffBBBBBB,100);
			myLine.graphics.moveTo(originX, originY-i*relevanceStep); 
			myLine.graphics.lineTo(timeMax, originY-i*relevanceStep);
			addChild(myLine);
			var relevanceLabel:TextField = new TextField();
			relevanceLabel.text = (i*10)+"";
			relevanceLabel.selectable = false;
			relevanceLabel.x=originX-50;
			relevanceLabel.y=originY-i*relevanceStep-10;
			addChild(relevanceLabel);
		}
		
		var yCoordinate:Shape = new Shape();
		yCoordinate.graphics.lineStyle(1,0x00000000,100);
		yCoordinate.graphics.moveTo(originX, originY); 
		yCoordinate.graphics.lineTo(originX, originY-relevanceMax);
		addChild(yCoordinate);
		
		var myFormat:TextFormat = new TextFormat(); 
		myFormat.bold =true;
		myFormat.size = 13;
		var yLabel:TextField = new TextField();
		yLabel.text = "Relevance(%)"
		yLabel.selectable = false;
		yLabel.x=originX-90;
		yLabel.y=10;
		yLabel.setTextFormat(myFormat);
		addChild(yLabel);
		
		var xCoordinate:Shape = new Shape();
		xCoordinate.graphics.lineStyle(1,0x00000000,100);
		xCoordinate.graphics.moveTo(originX, originY); 
		xCoordinate.graphics.lineTo(timeMax, originY);
		addChild(xCoordinate);
		
				
		var xLabel:TextField = new TextField();
		xLabel.text = "Age (days)"
		xLabel.selectable = false;
		xLabel.x=timeMax-50;
		xLabel.y=originY+30;
		xLabel.setTextFormat(myFormat);
		addChild(xLabel);
		
		for(i=1; i<timeMax/timeStep; i++){
			myLine = new Shape();
			myLine.graphics.lineStyle(1,0xffBBBBBB,100);
			myLine.graphics.moveTo(originX+i*timeStep, originY); 
			myLine.graphics.lineTo(originX+i*timeStep, 0);
			addChild(myLine);
			
			var timeLabel:TextField = new TextField();
			timeLabel.text = (i*5)+"";//each line indicate 5 days
			timeLabel.selectable = false;
			timeLabel.x=originX+i*timeStep;
			timeLabel.y=originY+10;
			addChild(timeLabel);
		}
	
		// Public Methods:
		// Protected Methods:
	}//
	
}//end of class
}//end of package
